<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_meta_data', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('enquiry_id');
            $table->unsignedBigInteger('enquiry_category_fields_id');
            $table->text('value')->nullable();
            $table->timestamps();

            // $table->unsignedBigInteger('enquiry_category_fields_id')->nullable();
            $table->foreign('contact_id')->references('id')->on('account_contacts');
            // $table->unsignedBigInteger('enquiry_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_meta_data');
    }
};
