<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('menu_model_permissios', function (Blueprint $table) {
            $table->decimal('priority')->default(0)->after('menu_name');
            $table->unsignedBigInteger('parent_id')->nullable()->after('priority');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('menu_model_permissios', function (Blueprint $table) {
            $table->dropColumn('priority');
            $table->dropColumn('parent_id');
        });
    }
};
