<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('style_types', function (Blueprint $table) {
            $table->id();

            $table->string('name')->nullable();
            $table->string('code')->nullable();
            $table->string('font_color')->nullable();
            $table->string('bg_color')->nullable();
            $table->string('font_family')->nullable();
            $table->string('text_decoration')->nullable();
            $table->string('font_size')->nullable();
            $table->string('font_style')->nullable();
            $table->string('font_weight')->nullable();
            $table->string('font_padding')->nullable();
            $table->boolean('is_default')->nullable()->default(0);
            $table->boolean('status')->nullable()->default(1);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('style_types');
    }
};
