<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('storage_settings', function (Blueprint $table) {
            $table->id();
            $table->string('storage_type', 255);
            $table->string('bucket_name', 255);
            $table->string('main_folder', 255)->nullable();
            $table->string('access_key', 255)->nullable();
            $table->string('secret_key', 255)->nullable();
            $table->string('region', 255)->nullable();
            $table->string('acl', 255)->nullable();
            $table->string('storage_max_upload_size', 255);
            $table->text('storage_validation');
            $table->string('storage_limit', 255)->nullable();
            $table->date('activation_date')->nullable();
            $table->date('renewal_date')->nullable();
            $table->date('next_renewal_date')->nullable();
            $table->unsignedTinyInteger('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('storage_settings');
    }
};
