<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('software_brandings', function (Blueprint $table) {
            $table->id();
            $table->string('company_name', 255)->nullable();
            $table->string('sales_email', 255)->nullable();
            $table->string('support_email', 255)->nullable();
            $table->string('sales_number', 255)->nullable();
            $table->string('support_number', 255)->nullable();
            $table->string('website', 255)->nullable();
            $table->string('facebook', 255)->nullable();
            $table->string('twitter', 255)->nullable();
            $table->string('linkedin', 255)->nullable();
            $table->text('sale_info')->nullable();
            $table->text('support_info')->nullable();
            $table->text('social_info')->nullable();
            $table->string('company_logo', 255)->nullable();
            $table->string('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('software_brandings');
    }
};
