<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('countries');
        Schema::create('countries', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255);
            $table->string('code', 255);
            $table->string('capital', 255)->nullable();
            $table->string('gsm_code', 255);
            $table->string('currency_fullname', 255);
            $table->string('currency_short_name', 255);
            $table->string('currency_symbol', 255);
            $table->decimal('priority');
            $table->string('sale_tax_type')->nullable();
            $table->boolean('status')->default(1);
            $table->string('formats');
            $table->string('financial_year_start_month', 5)->nullable();
            $table->string('financial_year_start_year', 5)->nullable();
            $table->string('financial_year_end_month', 5)->nullable();
            $table->string('financial_year_end_year', 5)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
};
