<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('tbl_financial_year');
        Schema::create('tbl_financial_year', function (Blueprint $table) {
            $table->id('financialyearid');
            $table->date('financial_year_start_date')->nullable();
            $table->date('financial_year_end_date')->nullable();
            $table->string('financial_year_name', 50)->nullable();
            $table->string('table_postfix', 50)->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->enum('status', ['0', '1'])->default('1');
            $table->enum('is_default', ['0', '1'])->default('0');
            $table->string('financial_year_short_code', 50)->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('company_id')->references('id')->on('companies');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_financial_year');
    }
};
