<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('account_contacts', function (Blueprint $table) {
            $table->text('any_known_allergies')->nullable()->after('city_id');
            $table->date('anniversary_date')->nullable()->after('city_id');
            $table->unsignedBigInteger('organization_type')->nullable();
            $table->string('guardian_name', 255)->nullable()->after('city_id');
            $table->string('postal_code', 255)->nullable()->after('city_id');
            $table->string('pin', 255)->nullable()->after('city_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_contacts', function (Blueprint $table) {
            if (Schema::hasColumn('companies_license_type', 'any_known_allergies')) {
                $table->dropColumn('any_known_allergies');
            }

            $table->dropColumn('organization_type');
            $table->dropColumn('anniversary_date');
            $table->dropColumn('guardian_name');
            $table->dropColumn('postal_code');
            $table->dropColumn('pin');
        });
    }
};
