<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->renameColumn('master_type_id', 'account_type_id');
            $table->renameColumn('master_category_id', 'account_category_id');
            $table->renameColumn('chart_of_account_sub_type_id', 'accounting_group_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->renameColumn('account_type_id', 'master_type_id');
            $table->renameColumn('account_category_id', 'master_category_id');
            $table->renameColumn('accounting_group_id', 'chart_of_account_sub_type_id');
        });
    }
};
