<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('account_banks', function (Blueprint $table) {
            $table->boolean('is_default')->default(0)->after('branch_name');
            $table->boolean('status')->default(1)->after('branch_name');
            $table->decimal('priority')->nullable()->after('branch_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_banks', function (Blueprint $table) {
            $table->dropColumn('is_default');
            $table->dropColumn('status');
            $table->dropColumn('priority');
        });
    }
};
