<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('accounting_types', function (Blueprint $table) {
            $table->string('code', 255)->nullable()->after('name');
            $table->string('priority', 255)->nullable()->after('name');
            $table->string('if_increase', 255)->nullable()->after('name');
            $table->string('if_decrease', 255)->nullable()->after('name');
            $table->boolean('is_default')->default(0)->after('name');
            $table->boolean('status')->default(1)->after('name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('accounting_types', function (Blueprint $table) {
            $table->dropColumn('code');
            $table->dropColumn('priority');
            $table->dropColumn('if_increase');
            $table->dropColumn('if_decrease');
            $table->dropColumn('is_default');
            $table->dropColumn('status');
        });
    }
};
