<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies_bank', function (Blueprint $table) {
            $table->boolean('is_default')->default(0)->after('upi_transaction_note');
            $table->boolean('status')->default(1)->after('upi_transaction_note');
            $table->decimal('priority')->nullable()->after('upi_transaction_note');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies_bank', function (Blueprint $table) {
            $table->dropColumn('is_default');
            $table->dropColumn('status');
            $table->dropColumn('priority');
        });
    }
};
