<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies_addresses', function (Blueprint $table) {
            $table->boolean('is_default')->default(0)->after('pin_code');
            $table->boolean('status')->default(1)->after('pin_code');
            $table->decimal('priority')->nullable()->after('pin_code');
            $table->string('district_name')->nullable()->after('pin_code');
            $table->string('taluka_name')->nullable()->after('pin_code');
            $table->unsignedBigInteger('address_type_id')->nullable()->after('pin_code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies_addresses', function (Blueprint $table) {
            $table->dropColumn('is_default');
            $table->dropColumn('status');
            $table->dropColumn('priority');
            $table->dropColumn('district_name');
            $table->dropColumn('taluka_name');
            $table->dropColumn('address_type_id');
        });
    }
};
