<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies_license', function (Blueprint $table) {
            $table->boolean('is_default')->default(0)->after('license_status');
            $table->decimal('priority')->nullable()->after('license_status');
            $table->unsignedBigInteger('license_type_id')->nullable()->after('license_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies_license', function (Blueprint $table) {
            $table->dropColumn('is_default');
            $table->dropColumn('priority');
            $table->dropColumn('license_type_id');
        });
    }
};
