<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('master_settings', function (Blueprint $table) {
            $table->id();
            $table->text('field')->nullable();
            $table->enum('type', ['text','textarea','radio','checkbox','select','hidden','date'])->default('text');
            $table->boolean('is_readonly')->default(0);
            $table->text('default_value')->nullable();
            $table->boolean('status')->default(1);
            $table->boolean('is_mandatory')->default(0);
            $table->text('select_options')->nullable();
            $table->string('code')->nullable();
            $table->string('remarks',64)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('master_settings');
    }
};
