<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->enum('letter_head', ['head_office','self'])->default('self')->after('is_default');
            $table->string('website')->nullable()->after('is_default');
            $table->string('deals_in')->nullable()->after('is_default');
            $table->text('tag_line')->nullable()->after('is_default');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('letter_head');
            $table->dropColumn('website');
            $table->dropColumn('deals_in');
            $table->dropColumn('tag_line');
        });
    }
};
