<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('short_name')->nullable();
            $table->text('description')->nullable();
            $table->string('shortcode')->nullable();
            $table->string('hsncode')->nullable();
            $table->unsignedInteger('tax_slab_id')->nullable();
            $table->unsignedInteger('brand_id')->nullable();
            $table->unsignedInteger('category_id')->nullable();
            $table->unsignedInteger('composition_id')->nullable();
            $table->unsignedInteger('primary_unit_id')->nullable();
            $table->unsignedInteger('alternative_unit_id')->nullable();
            $table->decimal('convertion_factor', 10, 2)->nullable();
            $table->string('priceasper')->nullable();
            $table->string('manage_stock')->nullable();
            $table->unsignedInteger('item_type_id')->nullable();
            $table->unsignedInteger('attribute_type_id')->nullable();
            $table->unsignedInteger('attribute_id')->nullable();
            $table->unsignedInteger('instance_id')->nullable();
            $table->text('image')->nullable();
            $table->text('file_path')->nullable();
            $table->boolean('status')->default(1);
            $table->boolean('sale_status')->default(1);
            $table->date('date')->nullable();
            $table->string('gender_id', 50)->nullable(false);
            $table->string('item_stock_type', 50)->nullable(false);
            $table->decimal('grossweight', 10, 5)->nullable(false);
            $table->decimal('netweight', 10, 5)->nullable(false);
            $table->unsignedInteger('purity')->nullable();
            $table->decimal('making_charge', 10, 2)->nullable(false);
            $table->decimal('additional_cost', 10, 2)->nullable(false);
            $table->text('item_sale_type')->nullable(false);
            $table->decimal('item_min_stock_qty', 10, 2)->nullable(false);
            $table->unsignedInteger('company_id')->nullable();
            $table->unsignedInteger('flag_id')->nullable();
            $table->unsignedInteger('warehouse_id')->nullable();
            $table->unsignedInteger('attribute_group_main')->nullable();
            $table->unsignedInteger('attribute_group_sub')->nullable();
            $table->unsignedInteger('enable_serial_number_tracking')->nullable();
            $table->unsignedInteger('allow_negative_stock')->nullable();
            $table->unsignedTinyInteger('is_raw_material')->nullable();
            $table->unsignedInteger('created_by_user_id')->nullable();
            $table->unsignedInteger('updated_by_user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
