<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_prices', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('product_id')->nullable();
            $table->unsignedInteger('main_attribute_id')->nullable();
            $table->unsignedInteger('sub_attribute_id')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->decimal('wholesale_price', 10, 2)->nullable();
            $table->decimal('sale_price', 10, 2)->nullable();
            $table->decimal('mrp', 10, 2)->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->decimal('min_sale_price', 10, 2)->nullable();
            $table->decimal('mfg_cost', 10, 2)->nullable();
            $table->text('bar_code')->nullable();
            $table->text('batch')->nullable();
            $table->text('opening_stock_pack')->nullable();
            $table->text('opening_stock_loose')->nullable();
            $table->text('opening_stock_value')->nullable();
            $table->date('exp_date')->nullable();
            $table->date('mfg_date')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_prices');
    }
};
