<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('organization_departments')) {
            Schema::create('organization_departments', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('details')->nullable();
                $table->decimal('priority')->nullable();
                $table->boolean('status')->default(1);
                $table->boolean('is_default')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('organization_departments');
    }
};
