<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_invoices', function (Blueprint $table) {
            $table->id();
            $table->text('main_invoice_no')->nullable();
            $table->string('branch_invoice_no')->nullable();
            $table->date('invoice_date')->nullable();
            $table->unsignedBigInteger('voucher_type_id')->nullable();
            $table->unsignedBigInteger('patient_id')->nullable();
            $table->unsignedBigInteger('doctor_id')->nullable();
            $table->unsignedBigInteger('collection_agent_id')->nullable();
            $table->unsignedBigInteger('refferal_lab_id')->nullable();
            $table->text('reff_no')->nullable();
            $table->unsignedBigInteger('payment_term_id')->nullable();
            $table->decimal('billing_amount', 10, 3)->nullable();
            $table->decimal('received_amount', 10, 3)->nullable();
            $table->decimal('discount_amount', 10, 3)->nullable();
            $table->decimal('due_amount', 10, 3)->nullable();
            $table->date('order_date')->nullable();
            $table->text('remarks_for_technician')->nullable();
            $table->text('remarks')->nullable();
            $table->date('sample_receive_date')->nullable();
            $table->time('sample_receive_time')->nullable();
            $table->text('sample_barcode')->nullable();
            $table->unsignedBigInteger('broker_id')->nullable();
            $table->unsignedBigInteger('operator_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->text('status')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->unsignedInteger('industry_type_id')->nullable();
            $table->unsignedBigInteger('dispatch_from_id')->nullable();
            $table->unsignedBigInteger('ship_to_id')->nullable();
            $table->unsignedBigInteger('tracking_id')->nullable();
            $table->unsignedBigInteger('special_case_id')->nullable();
            $table->unsignedBigInteger('voucher_master_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_invoices');
    }
};
