<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_invoice_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_invoice_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('product_price_id')->nullable();
            $table->text('item_batch')->nullable();
            $table->decimal('main_qty', 10, 2)->default(0);
            $table->decimal('alt_qty', 10, 2)->default(0);
            $table->decimal('free_qty', 10, 2)->default(0);
            $table->decimal('price', 10, 2)->default(0);
            $table->decimal('basic_amount', 10, 2)->default(0);
            $table->text('discount_percentage')->nullable();
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->unsignedBigInteger('tax_slab_id')->nullable();
            $table->string('tax_calculation_type')->nullable();
            $table->text('tax_cess_settings')->nullable();
            $table->decimal('tax_cess_amount', 10, 2)->default(0);
            $table->decimal('tax_special_cess_amount', 10, 2)->default(0);
            $table->decimal('total_amount', 10, 2)->default(0);
            $table->datetime('from_date_time')->nullable();
            $table->datetime('to_date_time')->nullable();
            $table->decimal('gross_weight', 13, 4)->default(0);
            $table->decimal('net_weight', 13, 4)->default(0);
            $table->decimal('charge_weight', 13, 4)->default(0);
            $table->decimal('making_charge', 13, 4)->default(0);
            $table->decimal('additional_cost', 13, 4)->default(0);
            $table->decimal('other_charges', 10, 4)->default(0);
            $table->unsignedBigInteger('godown_id')->nullable();
            $table->text('item_details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_invoice_details');
    }
};
