<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    { 
        Schema::create('sale_invoice_sub_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_invoice_detail_id')->nullable();
            $table->unsignedBigInteger('sale_invoice_id')->nullable();
            // $table->unsignedBigInteger('testpackage_id')->nullable();
            $table->text('subdetails_remarks')->nullable();
            $table->boolean('status')->default(1);
            $table->string('referrence_type', 20)->nullable()->comment('TESTPACKAGE, OPD, IPD, LAB');
            $table->unsignedBigInteger('data_referrence_id')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_invoice_sub_details');
    }
};
