<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_uploads', function (Blueprint $table) {
            $table->id();
            $table->string('account_name')->nullable();
            $table->string('print_name')->nullable();
            $table->string('account_code')->nullable();
            $table->string('group_name')->nullable();
            $table->text('address_line_1')->nullable();
            $table->text('address_line_2')->nullable();
            $table->string('pin_code')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('phone')->nullable();
            $table->string('mobile')->nullable();
            $table->string('email')->nullable();
            $table->string('pan_no')->nullable();
            $table->string('gst_no')->nullable();
            $table->string('cst_no')->nullable();
            $table->string('vat_no')->nullable();
            $table->string('aadhaar_no')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->string('account_no')->nullable();
            $table->string('ifsc_code')->nullable();
            $table->string('license_1')->nullable();
            $table->string('license_2')->nullable();
            $table->string('settlement_type')->nullable();
            $table->string('division_area_name')->nullable();
            $table->string('party_group_name')->nullable();
            $table->string('default_payment_mode')->nullable();
            $table->decimal('opening_balance', 10, 2)->nullable();
            $table->decimal('credit_limit', 10, 2)->nullable();
            $table->decimal('bill_limit', 10, 2)->nullable();
            $table->text('remarks')->nullable();
            $table->enum('status', ['0', '1'])->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_uploads');
    }
};
