<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_uploads', function (Blueprint $table) {
            $table->id();
            $table->string('product_name')->nullable();
            $table->string('product_short_name')->nullable();
            $table->string('product_short_code')->nullable();
            $table->string('product_hsn')->nullable();
            $table->string('barcode')->nullable();
            $table->string('batch')->nullable();
            $table->string('brand')->nullable();
            $table->string('category')->nullable();
            $table->string('composition')->nullable();
            $table->string('primary_unit')->nullable();
            $table->string('alternative_unit')->nullable();
            $table->string('tax')->nullable();
            $table->string('main_attribute_group')->nullable();
            $table->string('main_attribute_name')->nullable();
            $table->string('sub_attribute_group')->nullable();
            $table->string('sub_attribute_name')->nullable();
            $table->text('product_description')->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->decimal('sale_price', 10, 2)->nullable();
            $table->decimal('product_mrp', 10, 2)->nullable();
            $table->decimal('minimum_sale_price', 10, 2)->nullable();
            $table->decimal('opening_stock_pack', 10, 2)->nullable();
            $table->decimal('opening_stock_loose', 10, 2)->nullable();
            $table->decimal('opening_stock_value', 10, 2)->nullable();
            $table->decimal('min_stock_qty', 10, 2)->nullable();
            $table->decimal('conversion_factor', 10, 2)->nullable();
            $table->date('mfg_date')->nullable();
            $table->date('exp_date')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('manage_stock')->nullable();
            $table->string('business_division')->nullable();
            $table->enum('status', ['0', '1'])->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_uploads');
    }
};
