<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ac_journals', function (Blueprint $table) {
            $table->id();
            $table->string('voucher_no','12');
            $table->date('transaction_date');
            $table->string('reference','191')->nullable();
            $table->text('description');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('financial_year_id');
            $table->boolean('journal_status');
            $table->unsignedInteger('created_by')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ac_journals');
    }
};
