<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ac_journal_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transactions_no',16);
            $table->date('transaction_date');
            $table->unsignedInteger('module_id');
            $table->unsignedBigInteger('voucher_id')->comment('journal_id');
            $table->string('voucher_type',25)->comment('SALE, PURCHASE, PAYMENT');
            $table->unsignedBigInteger('account_id')->comment('From Account Table');
            $table->enum('transaction_type',['DEBIT','CREDIT'])->comment('DEBIT,CREDIT');
            $table->tinytext('details_narration');
            $table->decimal('amount',13,4)->default('0.0000');
            $table->unsignedInteger('created_by')->default('0');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('financial_year_id');
            $table->boolean('transactions_status');            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ac_journal_transactions');
    }
};
