<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voucher_series', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('voucher_type_id');
            $table->string('series_name');
            $table->integer('length')->default(3);
            $table->integer('start_from')->default(1);
            $table->string('prefix')->nullable();
            $table->string('postfix')->nullable();
            $table->enum('frequency', ['Start From Zero (0) Every Year', 'Follow Last Year'])->default('Start From Zero (0) Every Year');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voucher_series');
    }
};
