<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sms_api_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->string('user_name', 255)->nullable();
            $table->string('password', 255)->nullable();
            $table->string('principal_entity_id', 255)->nullable();
            $table->string('sms_signature', 255)->nullable();
            $table->string('sms_notify_mobile', 255)->nullable();
            $table->string('sms_notify_email', 255)->nullable();
            $table->string('sms_notify_url', 255)->nullable();
            $table->string('enable_sms_api', 255)->nullable();
            $table->enum('status', ['0', '1'])->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sms_api_settings');
    }
};
