<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_invoice_deliveries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_invoice_id')->nullable();
            $table->unsignedBigInteger('sale_invoice_detail_id')->nullable();
            $table->unsignedBigInteger('delivery_partner_id')->nullable();
            $table->date('delivery_date')->nullable();
            $table->time('delivery_time')->nullable();
            $table->decimal('delivery_charge', 10, 3);
            $table->text('delivery_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_invoice_deliveries');
    }
};
