<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('date_format')->nullable()->after('status');
            $table->string('time_format')->nullable()->after('status');
            $table->string('time_zone')->nullable()->after('status');
            $table->unsignedBigInteger('language_id')->nullable()->after('status');
            $table->unsignedBigInteger('currency_id')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('date_format');
            $table->dropColumn('time_format');
            $table->dropColumn('time_zone');
            $table->dropColumn('language_id');
            $table->dropColumn('currency_id');
        });
    }
};
