<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ac_journals', function (Blueprint $table) {
            $table->boolean('voucher_approval_status')->default(0)->comment('1 Approved, 0 Not Approved')->after('created_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ac_journals', function (Blueprint $table) {
            $table->dropColumn('voucher_approval_status');
        });
    }
};
