<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ac_receipt_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_mode_id')->nullable();
            $table->integer('voucher_master_id')->nullable();
            $table->unsignedBigInteger('voucher_id')->comment('receipt_id');
            $table->string('voucher_type',25)->comment('SALE, PURCHASE, PAYMENT');
            $table->unsignedInteger('module_id');
            $table->unsignedBigInteger('account_id')->comment('From Account Table');
            $table->enum('transaction_type',['DEBIT','CREDIT'])->comment('DEBIT,CREDIT');
            $table->tinytext('details_narration')->nullable();
            $table->decimal('amount',13,4)->default('0.0000');
            $table->unsignedInteger('currency_id')->default('0');
            $table->unsignedInteger('created_by')->default('0');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('financial_year_id');
            $table->boolean('transactions_status');            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ac_receipt_details');
    }
};
