<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ac_receipts', function (Blueprint $table) {
            $table->id();
            $table->string('receipt_no',25)->nullable();
            $table->string('overall_receipt_no',25)->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->date('collection_date')->nullable();
            $table->decimal('collection_amount',13,4)->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ac_receipts');
    }
};
