<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->dropColumn('account_id');
            $table->dropColumn('collection_amount');
            $table->renameColumn('collection_date', 'receipt_date');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->unsignedInteger('deleted_by')->nullable();
            $table->boolean('voucher_status')->default(0);
            $table->string('last_voucher_count',25);
            $table->datetime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->dropColumn('company_id');
            $table->dropColumn('created_by');
            $table->dropColumn('updated_by');
            $table->dropColumn('deleted_by');
            $table->dropColumn('voucher_status');
            $table->dropColumn('last_voucher_count');
            $table->dropColumn('deleted_at');
        });
    }
};
