<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('client_license_validities')) {
            Schema::create('client_license_validities', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('license_id')->nullable();
                $table->date('activation_date')->nullable();
                $table->date('valid_upto')->nullable();
                $table->date('grace_period')->nullable();
                $table->boolean('payment_status')->default('1');
                $table->boolean('status')->default(1);
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_license_validities');
    }
};
