<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('client_licenses')) {
            Schema::create('client_licenses', function (Blueprint $table) {
                $table->id(); 
                $table->string('unique_client_code')->nullable();
                $table->unsignedBigInteger('client_mail_id')->nullable();
                $table->string('product_code')->nullable();
                $table->string('license_no')->nullable();
                $table->string('license_key')->nullable();
                $table->date('registration_date')->nullable();
                $table->enum('status', ['0', '1'])->default('1')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_licenses');
    }
};
