<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ac_receipt_details', function (Blueprint $table) {
            if (Schema::hasColumn('ac_receipt_details', 'currency_id')) {
                $table->dropColumn('currency_id');
            }

            if (Schema::hasColumn('ac_receipt_details', 'financial_year_id')) {
                $table->dropColumn('financial_year_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ac_receipt_details', function (Blueprint $table) {
            if (Schema::hasColumn('ac_receipt_details', 'currency_id')) {
                $table->dropColumn('currency_id');
            }

            if (Schema::hasColumn('ac_receipt_details', 'financial_year_id')) {
                $table->dropColumn('financial_year_id');
            }
        });
    }
};
