<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id')->nullable();
            $table->string('title',150)->nullable();
            $table->string('sub_title',150)->nullable();
            $table->mediumText('content')->nullable();
            $table->string('text_direction',100)->nullable();
            $table->enum('button_enable',['0','1'])->default('0');
            $table->string('btn_text',150)->nullable();
            $table->text('btn_enquiry_link')->nullable();
            $table->text('btn2_text')->nullable();
            $table->text('btn2_enquiry_link')->nullable();
            $table->string('redirect_url',150)->nullable();
            $table->mediumText('image')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->decimal('priority_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sliders');
    }
};
