<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('public_content_category', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->decimal('priority_status')->nullable();
            $table->enum('new_tag',['Yes','No'])->default('Yes')->nullable();
            $table->enum('status',['1','0'])->default('1')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('public_content_category');
    }
};
