<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('card_types', function (Blueprint $table) {
            $table->id();
            $table->string('name',120)->nullable();
            $table->integer('book_limit')->nullable();
            $table->string('library_card_serial',120)->nullable();
            $table->integer('card_no_length')->nullable();
            $table->string('serial_start_from',120)->nullable();
            $table->string('prefix_code',120)->nullable();
            $table->string('suffix_code',120)->nullable();
            $table->enum('status',['0','1'])->default('1')->comment('1 is active and 0 is deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('card_types');
    }
};
