<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('public_contents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('public_content_category_id')->nullable();
            $table->unsignedBigInteger('sub_category_id')->nullable();
            $table->string('title',150)->index()->nullable();
            $table->text('description')->nullable();
            $table->text('link')->nullable();
            $table->mediumText('files')->nullable();
            $table->decimal('prority_status',50)->nullable();
            $table->enum('new_tag',['Yes','No'])->default('Yes');
            $table->enum('status',['1','0'])->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('public_contents');
    }
};
