<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_photo_gallery_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('photo_gallery_id')->nullable();
            $table->string('image_name',120)->nullable();
            $table->mediumText('image')->nullable();
            $table->decimal('priority',20)->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->foreign('photo_gallery_id')->references('id')->on('tbl_photo_gallery')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_photo_gallery_images');
    }
};
