<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('title', 70)->nullable();
            $table->mediumText('description')->nullable();
            $table->string('image')->nullable();
            $table->text('video_url')->nullable();
            $table->text('body')->nullable();
            $table->string('slug')->unique();
            $table->enum('post_type',['page','post','product'])->default('page');
            $table->string('meta_title')->nullable();
            $table->string('meta_key')->nullable();
            $table->string('meta_url')->nullable();
            $table->string('meta_image')->nullable();
            $table->string('meta_description')->nullable();
            $table->enum('status',['0','1','2'])->default('1');
            $table->string('view_count',50)->nullable();
            $table->unsignedBigInteger('category_id')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
};
