<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies_license_type', function (Blueprint $table) {
            $table->integer('data_length')->default(20)->after('license_status');
            $table->enum('value_type',['number','text','number_and_text'])->default('number_and_text')->after('license_status');
            $table->boolean('is_mandatory')->default(0)->after('license_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies_license_type', function (Blueprint $table) {
            $table->dropColumn('data_length');
            $table->dropColumn('value_type');
            $table->dropColumn('is_mandatory');
        });
    }
};
