<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('account_types', function (Blueprint $table) {
            $table->unsignedBigInteger('accounting_group_id')->nullable()->after('type_name');
            $table->unsignedBigInteger('account_category_id')->nullable()->after('accounting_group_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_types', function (Blueprint $table) {
            $table->dropColumn('accounting_group_id');
            $table->dropColumn('account_category_id');
        });
    }
};
