<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('e_way_bill_apis', function (Blueprint $table) {
            $table->string('api_type')->nullable()->after('company_id');
            $table->boolean('is_default')->default(0)->after('api_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('e_way_bill_apis', function (Blueprint $table) {
            $table->dropColumn('api_type');
            $table->dropColumn('is_default');
        });
    }
};
