<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('marketings', function (Blueprint $table) {
            $table->id(); 
            $table->string('business_name')->nullable();
            $table->string('gbp_link')->nullable();
            $table->string('rating')->nullable();
            $table->string('total_review')->nullable();
            $table->string('address')->nullable();
            $table->string('website')->nullable(); 
            $table->string('phone_number')->nullable();
            $table->string('email')->nullable();
            $table->string('claim_status')->nullable();
            $table->string('optimization_score')->nullable();
            $table->string('local_ads')->nullable();
            $table->string('paid_ads')->nullable();
            $table->string('google_ranking')->nullable();
            $table->string('pack_ranking')->nullable();
            $table->string('ai_suggested_services')->nullable();
            $table->string('note')->nullable();
            $table->string('tags')->nullable();
            $table->unsignedBigInteger('business_category_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('marketings');
    }
};
