<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->index('house_group_id');
            $table->index('account_title_id');
            $table->index('accounting_group_id');
            $table->index('account_category_id');
            $table->index('account_type_id');
        });

        Schema::table('account_categories', function (Blueprint $table) {
            $table->index('account_type_id');
        });

        Schema::table('account_licenses', function (Blueprint $table) {
            $table->index('license_type_id');
        });

        Schema::table('account_payments', function (Blueprint $table) {
            $table->index('payment_mode_id');
        });

        Schema::table('account_relatives_details', function (Blueprint $table) {
            $table->index('account_id');
        });

        Schema::table('account_contacts', function (Blueprint $table) {
            $table->index('account_gender_id');
            $table->index('blood_group_id');
            $table->index('country_id');
            $table->index('state_id');
            $table->index('city_id');
        });

        Schema::table('account_types', function (Blueprint $table) {
            $table->index('accounting_group_id');
            $table->index('account_category_id');
        });

        Schema::table('ac_journals', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('financial_year_id');
        });

        Schema::table('ac_journal_transactions', function (Blueprint $table) {
            $table->index('module_id');
            $table->index('voucher_id');
            $table->index('account_id');
            $table->index('currency_id');
            $table->index('company_id');
            $table->index('financial_year_id');
        });

        Schema::table('ac_opening_balances', function (Blueprint $table) {
            $table->index('account_id');
            $table->index('company_id');
            $table->index('financial_year_id');
        });

        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->index('company_id');
        });

        Schema::table('ac_receipt_details', function (Blueprint $table) {
            $table->index('payment_mode_id');
            $table->index('voucher_master_id');
            $table->index('voucher_id');
            $table->index('module_id');
            $table->index('account_id');
            $table->index('company_id');
        });

        /*Schema::table('appointment_doctor_fees', function (Blueprint $table) {
            $table->index('doctor_id');
            $table->index('shift_id');
            $table->index('product_id');
        });

        Schema::table('appointment_doctor_schedules', function (Blueprint $table) {
            $table->index('doctor_id');
            $table->index('shift_id');
        });

        Schema::table('appointment_doctor_shifts', function (Blueprint $table) {
            $table->index('doctor_id');
            $table->index('shift_id');
        });

        Schema::table('appointment_doctor_shift_days', function (Blueprint $table) {
            $table->index('doctor_id');
            $table->index('shift_id');
            $table->index('day_id');
        });*/

        /*Schema::table('beds', function (Blueprint $table) {
            $table->index('bed_type_id');
            $table->index('bed_group_id');
        });

        Schema::table('bed_groups', function (Blueprint $table) {
            $table->index('floor_id');
            $table->index('building_id');
        });*/

        /*Schema::table('book_details', function (Blueprint $table) {
            $table->index('book_id');
            $table->index('book_format_id');
            $table->index('author_id');
            $table->index('publisher_id');
            $table->index('stream_id');
            $table->index('translator_id');
            $table->index('laguages_id');
            $table->index('book_class_id');
            $table->index('book_tag_id');
        });*/

        Schema::table('cities', function (Blueprint $table) {
            $table->index('state_id');
        });

        Schema::table('clients', function (Blueprint $table) {
            $table->index('country_id');
            $table->index('state_id');
            $table->index('city_id');
        });

        Schema::table('client_licenses', function (Blueprint $table) {
            $table->index('client_mail_id');
        });

        Schema::table('client_license_validities', function (Blueprint $table) {
            $table->index('license_id');
        });

        Schema::table('companies', function (Blueprint $table) {
            $table->index('currency_id');
            $table->index('language_id');
            $table->index('establishment_type_id');
        });

        Schema::table('companies_addresses', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('country_id');
            $table->index('state_id');
            $table->index('city_id');
            $table->index('address_type_id');
        });

        Schema::table('companies_bank', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('upi_id');
        });

        Schema::table('companies_license', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('license_type_id');
        });

        Schema::table('companies_license_type', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('country_id');
        });

        Schema::table('country_currencies', function (Blueprint $table) {
            $table->index('country_id');
        });

        /*Schema::table('doctors', function (Blueprint $table) {
            $table->index('account_id');
            $table->index('organization_department_id');
            $table->index('opd_schedule_types_id');
            $table->index('shift_id');
        });

        Schema::table('doctor_fees', function (Blueprint $table) {
            $table->index('doctor_id');
            $table->index('shift_id');
        });*/

        Schema::table('document_types', function (Blueprint $table) {
            $table->index('country_id');
        });

        /*Schema::table('enquiries', function (Blueprint $table) {
            $table->index('contact_id');
        });

        Schema::table('enquiry_attachments', function (Blueprint $table) {
            $table->index('attachments_id');
        });

        Schema::table('enquiry_contacts', function (Blueprint $table) {
            $table->index('account_gender_id');
            $table->index('blood_group_id');
            $table->index('country_id');
            $table->index('state_id');
            $table->index('city_id');
        });

        Schema::table('enquiry_social_media_links', function (Blueprint $table) {
            $table->index('platform_id');
        });*/

        Schema::table('e_invoice_apis', function (Blueprint $table) {
            $table->index('client_id');
            $table->index('company_id');
        });

        Schema::table('e_way_bill_apis', function (Blueprint $table) {
            $table->index('client_id');
            $table->index('company_id');
        });

        /*Schema::table('findings', function (Blueprint $table) {
            $table->index('finding_category_id');
        });*/

        Schema::table('floors', function (Blueprint $table) {
            $table->index('building_id');
        });

        /*Schema::table('incentive_settings', function (Blueprint $table) {
            $table->index('account_id');
            $table->index('slab_id');
        });

        Schema::table('incentive_slabs', function (Blueprint $table) {
            $table->index('account_type_id');
            $table->index('company_id');
        });

        Schema::table('incentive_slab_details', function (Blueprint $table) {
            $table->index('slab_id');
            $table->index('product_id');
        });*/

        Schema::table('invoice_serial_settings', function (Blueprint $table) {
            $table->index('invoice_type_id');
            $table->index('company_id');
            $table->index('financial_year_id');
        });

        /*Schema::table('ipd_admissions', function (Blueprint $table) {
            $table->index('patient_id');
            $table->index('patient_source_id');
            $table->index('tpa_account_id');
        });

        Schema::table('ipd_bed_histories', function (Blueprint $table) {
            $table->index('ipd_admission_id');
            $table->index('bed_group_id');
            $table->index('bed_no_id');
        });

        Schema::table('ipd_body_vital_histories', function (Blueprint $table) {
            $table->index('ipd_admission_id');
            $table->index('body_vital_id');
        });

        Schema::table('ipd_consultant_histories', function (Blueprint $table) {
            $table->index('ipd_admission_id');
            $table->index('doctor_id');
        });

        Schema::table('ipd_symptom_histories', function (Blueprint $table) {
            $table->index('ipd_admission_id');
            $table->index('symptom_id');
        });*/

        /*Schema::table('librarian_publishers', function (Blueprint $table) {
            $table->index('place_id');
        });*/

        Schema::table('license_types', function (Blueprint $table) {
            $table->index('country_id');
        });

        /*Schema::table('lms_assignments', function (Blueprint $table) {
            $table->index('course_id');
        });

        Schema::table('lms_class_sections', function (Blueprint $table) {
            $table->index('class_id');
            $table->index('academics_section_id');
        });

        Schema::table('lms_courses', function (Blueprint $table) {
            $table->index('category_id');
            $table->index('language_id');
            $table->index('subject_id');
            $table->index('company_id');
            $table->index('class_id');
            $table->index('section_id');
        });

        Schema::table('lms_course_categories', function (Blueprint $table) {
            $table->index('parent_id');
        });

        Schema::table('lms_video_sources', function (Blueprint $table) {
            $table->index('course_id');
        });*/

        Schema::table('operations', function (Blueprint $table) {
            $table->index('category_id');
        });

        Schema::table('posts', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('category_id');
        });

        Schema::table('price_settings', function (Blueprint $table) {
            $table->index('master_voucher_id');
        });

        Schema::table('products', function (Blueprint $table) {
            $table->index('tax_slab_id');
            $table->index('brand_id');
            $table->index('category_id');
            $table->index('composition_id');
            $table->index('primary_unit_id');
            $table->index('alternative_unit_id');
            $table->index('item_type_id');
            $table->index('attribute_type_id');
            $table->index('attribute_id');
            $table->index('instance_id');
            $table->index('gender_id');
            $table->index('company_id');
            $table->index('flag_id');
            $table->index('warehouse_id');
            $table->index('created_by_user_id');
            $table->index('updated_by_user_id');
        });

        Schema::table('product_alternative_units', function (Blueprint $table) {
            $table->index('primary_unit_id');
            $table->index('company_id');
        });

        Schema::table('product_attributes', function (Blueprint $table) {
            $table->index('product_attribute_type_id');
        });

        Schema::table('product_images', function (Blueprint $table) {
            $table->index('product_id');
        });

        Schema::table('product_locations', function (Blueprint $table) {
            $table->index('product_id');
            $table->index('company_id');
            $table->index('location_rack_id');
        });

        Schema::table('product_location_racks', function (Blueprint $table) {
            $table->index('warehouse_id');
            $table->index('company_id');
        });

        Schema::table('product_prices', function (Blueprint $table) {
            $table->index('product_id');
            $table->index('main_attribute_id');
            $table->index('sub_attribute_id');
            $table->index('company_id');
        });

        Schema::table('product_test_packages', function (Blueprint $table) {
            $table->index('product_id');
            $table->index('test_package_id');
        });

        Schema::table('product_uploads', function (Blueprint $table) {
            $table->index('company_id');
        });

        Schema::table('product_warehouses', function (Blueprint $table) {
            $table->index('state_id');
            $table->index('country_id');
            $table->index('company_id');
        });

        Schema::table('public_contents', function (Blueprint $table) {
            $table->index('public_content_category_id');
            $table->index('sub_category_id');
        });

        Schema::table('sale_invoices', function (Blueprint $table) {
            if (Schema::hasColumn('sale_invoices', 'voucher_type_id')) {
                $table->index('voucher_type_id');
            }
            $table->index('patient_id');
            $table->index('doctor_id');
            $table->index('collection_agent_id');
            $table->index('refferal_lab_id');
            $table->index('payment_mode_id');
            $table->index('bussiness_source_id');
            $table->index('payment_term_id');
            $table->index('broker_id');
            $table->index('operator_id');
            $table->index('company_id');
            $table->index('financial_year_id');
            $table->index('industry_type_id');
            $table->index('dispatch_from_id');
            $table->index('ship_to_id');
            $table->index('tracking_id');
            $table->index('special_case_id');
        });

        Schema::table('sale_invoice_deliveries', function (Blueprint $table) {
            $table->index('sale_invoice_id');
            $table->index('sale_invoice_detail_id');
            $table->index('delivery_partner_id');
        });

        Schema::table('sale_invoice_details', function (Blueprint $table) {
            $table->index('sale_invoice_id');
            $table->index('product_id');
            $table->index('product_price_id');
            $table->index('tax_slab_id');
            $table->index('godown_id');
        });

        Schema::table('sale_invoice_sub_details', function (Blueprint $table) {
            $table->index('sale_invoice_detail_id');
            $table->index('sale_invoice_id');
            $table->index('data_referrence_id');
        });

        Schema::table('sale_invoice_walk_in_customers', function (Blueprint $table) {
            $table->index('invoice_id');
            $table->index('gender_id');
        });

        /*Schema::table('sample_types', function (Blueprint $table) {
            $table->index('sample_collection_tube_id');
        });*/

        Schema::table('signature_permissions', function (Blueprint $table) {
            $table->index('signatures_id');
            $table->index('test_departments_id');
        });

        Schema::table('sliders', function (Blueprint $table) {
            $table->index('company_id');
        });

        Schema::table('sms_api_settings', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('principal_entity_id');
        });

        Schema::table('sms_templates', function (Blueprint $table) {
            $table->index('company_id');
            $table->index('template_id');
            $table->index('sender_id');
        });

        Schema::table('states', function (Blueprint $table) {
            $table->index('country_id');
        });

        /*Schema::table('student_admissions', function (Blueprint $table) {
            $table->index('student_id');
            $table->index('financial_id');
            $table->index('class_id');
            $table->index('section_id');
        });*/

        Schema::table('tax_calculations', function (Blueprint $table) {
            $table->index('voucher_master_id');
        });

        Schema::table('tax_masters', function (Blueprint $table) {
            $table->index('tax_category_id');
        });

        Schema::table('tax_master_subs', function (Blueprint $table) {
            $table->index('tax_master_id');
        });

        Schema::table('tbl_stocks', function (Blueprint $table) {
            $table->index('financial_id');
            $table->index('invoice_id');
            $table->index('stock_item_id');
            $table->index('stock_item_price_id');
            $table->index('stock_item_attribute_id');
            $table->index('stock_company_id');
        });

        /*Schema::table('tc_registers', function (Blueprint $table) {
            $table->index('account_id');
            $table->index('class_id');
        });*/

        /*Schema::table('test_dept_permissions', function (Blueprint $table) {
            $table->index('user_id');
            $table->index('test_departments_id');
        });

        Schema::table('test_items', function (Blueprint $table) {
            $table->index('primary_unit_id');
            $table->index('test_method_id');
            $table->index('machine_id');
        });

        Schema::table('test_item_normal_ranges', function (Blueprint $table) {
            $table->index('test_item_id');
            $table->index('special_case_id');
            $table->index('gender_id');
        });

        Schema::table('test_item_options', function (Blueprint $table) {
            $table->index('test_item_id');
            $table->index('style_type_id');
        });

        Schema::table('test_packages', function (Blueprint $table) {
            $table->index('department_id');
            $table->index('sample_type_id');
        });

        Schema::table('test_package_groups', function (Blueprint $table) {
            $table->index('test_package_id');
        });

        Schema::table('test_package_group_notes', function (Blueprint $table) {
            $table->index('test_package_id');
            $table->index('test_package_group_id');
        });

        Schema::table('test_package_group_test_items', function (Blueprint $table) {
            $table->index('test_package_id');
            $table->index('test_package_group_id');
            $table->index('test_item_id');
        });

        Schema::table('test_package_notes', function (Blueprint $table) {
            $table->index('test_package_id');
        });*/

        Schema::table('users', function (Blueprint $table) {
            $table->index('account_id');
            $table->index('company_id');
        });

        Schema::table('voucher_series', function (Blueprint $table) {
            $table->index('voucher_type_id');
        });

        Schema::table('voucher_types', function (Blueprint $table) {
            $table->index('voucher_master_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('accounts', function (Blueprint $table) {
            /*$schema_builder = Schema::getConnection()
                ->getDoctrineSchemaManager()
                ->listTableDetails( $table->getTable() );

            if( $schema_builder->hasIndex('house_group_id') ) {
                $table->dropIndex(['house_group_id']);
            }*/

            $table->dropIndex(['account_title_id']);
            $table->dropIndex(['accounting_group_id']);
            $table->dropIndex(['account_category_id']);
            $table->dropIndex(['account_type_id']);
        });

        Schema::table('account_categories', function (Blueprint $table) {
            $table->dropIndex(['account_type_id']);
        });

        Schema::table('account_licenses', function (Blueprint $table) {
            $table->dropIndex(['license_type_id']);
        });

        Schema::table('account_payments', function (Blueprint $table) {
            $table->dropIndex(['payment_mode_id']);
        });

        Schema::table('account_relatives_details', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
        });

        Schema::table('account_contacts', function (Blueprint $table) {
            $table->dropIndex(['account_gender_id']);
            $table->dropIndex(['blood_group_id']);
            $table->dropIndex(['country_id']);
            $table->dropIndex(['state_id']);
            $table->dropIndex(['city_id']);
        });

        Schema::table('account_types', function (Blueprint $table) {
            $table->dropIndex(['accounting_group_id']);
            $table->dropIndex(['account_category_id']);
        });

        Schema::table('ac_journals', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['financial_year_id']);
        });

        Schema::table('ac_journal_transactions', function (Blueprint $table) {
            $table->dropIndex(['module_id']);
            $table->dropIndex(['voucher_id']);
            $table->dropIndex(['account_id']);
            $table->dropIndex(['currency_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['financial_year_id']);
        });

        Schema::table('ac_opening_balances', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['financial_year_id']);
        });

        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
        });

        Schema::table('ac_receipt_details', function (Blueprint $table) {
            $table->dropIndex(['payment_mode_id']);
            $table->dropIndex(['voucher_master_id']);
            $table->dropIndex(['voucher_id']);
            $table->dropIndex(['module_id']);
            $table->dropIndex(['account_id']);
            $table->dropIndex(['company_id']);
        });

        /*Schema::table('appointment_doctor_fees', function (Blueprint $table) {
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['shift_id']);
            $table->dropIndex(['product_id']);
        });

        Schema::table('appointment_doctor_schedules', function (Blueprint $table) {
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['shift_id']);
        });

        Schema::table('appointment_doctor_shifts', function (Blueprint $table) {
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['shift_id']);
        });

        Schema::table('appointment_doctor_shift_days', function (Blueprint $table) {
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['shift_id']);
            $table->dropIndex(['day_id']);
        });*/

        /*Schema::table('beds', function (Blueprint $table) {
            $table->dropIndex(['bed_type_id']);
            $table->dropIndex(['bed_group_id']);
        });

        Schema::table('bed_groups', function (Blueprint $table) {
            $table->dropIndex(['floor_id']);
            $table->dropIndex(['building_id']);
        });*/

        /*Schema::table('book_details', function (Blueprint $table) {
            $table->dropIndex(['book_id']);
            $table->dropIndex(['book_format_id']);
            $table->dropIndex(['author_id']);
            $table->dropIndex(['publisher_id']);
            $table->dropIndex(['stream_id']);
            $table->dropIndex(['translator_id']);
            $table->dropIndex(['laguages_id']);
            $table->dropIndex(['book_class_id']);
            $table->dropIndex(['book_tag_id']);
        });*/

        Schema::table('cities', function (Blueprint $table) {
            $table->dropIndex(['state_id']);
        });

        Schema::table('clients', function (Blueprint $table) {
            $table->dropIndex(['country_id']);
            $table->dropIndex(['state_id']);
            $table->dropIndex(['city_id']);
        });

        Schema::table('client_licenses', function (Blueprint $table) {
            $table->dropIndex(['client_mail_id']);
        });

        Schema::table('client_license_validities', function (Blueprint $table) {
            $table->dropIndex(['license_id']);
        });

        Schema::table('companies', function (Blueprint $table) {
            $table->dropIndex(['currency_id']);
            $table->dropIndex(['language_id']);
            $table->dropIndex(['establishment_type_id']);
        });

        Schema::table('companies_addresses', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['country_id']);
            $table->dropIndex(['state_id']);
            $table->dropIndex(['city_id']);
            $table->dropIndex(['address_type_id']);
        });

        Schema::table('companies_bank', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['upi_id']);
        });

        Schema::table('companies_license', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['license_type_id']);
        });

        Schema::table('companies_license_type', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['country_id']);
        });

        Schema::table('country_currencies', function (Blueprint $table) {
            $table->dropIndex(['country_id']);
        });

        /*Schema::table('doctors', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
            $table->dropIndex(['organization_department_id']);
            $table->dropIndex(['opd_schedule_types_id']);
            $table->dropIndex(['shift_id']);
        });

        Schema::table('doctor_fees', function (Blueprint $table) {
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['shift_id']);
        });*/

        Schema::table('document_types', function (Blueprint $table) {
            $table->dropIndex(['country_id']);
        });

        /*Schema::table('enquiries', function (Blueprint $table) {
            $table->dropIndex(['contact_id']);
        });

        Schema::table('enquiry_attachments', function (Blueprint $table) {
            $table->dropIndex(['attachments_id']);
        });

        Schema::table('enquiry_contacts', function (Blueprint $table) {
            $table->dropIndex(['account_gender_id']);
            $table->dropIndex(['blood_group_id']);
            $table->dropIndex(['country_id']);
            $table->dropIndex(['state_id']);
            $table->dropIndex(['city_id']);
        });

        Schema::table('enquiry_social_media_links', function (Blueprint $table) {
            $table->dropIndex(['platform_id']);
        });*/

        Schema::table('e_invoice_apis', function (Blueprint $table) {
            $table->dropIndex(['client_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('e_way_bill_apis', function (Blueprint $table) {
            $table->dropIndex(['client_id']);
            $table->dropIndex(['company_id']);
        });

        /*Schema::table('findings', function (Blueprint $table) {
            $table->dropIndex(['finding_category_id']);
        });*/

        Schema::table('floors', function (Blueprint $table) {
            $table->dropIndex(['building_id']);
        });

        /*Schema::table('incentive_settings', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
            $table->dropIndex(['slab_id']);
        });

        Schema::table('incentive_slabs', function (Blueprint $table) {
            $table->dropIndex(['account_type_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('incentive_slab_details', function (Blueprint $table) {
            $table->dropIndex(['slab_id']);
            $table->dropIndex(['product_id']);
        });*/

        Schema::table('invoice_serial_settings', function (Blueprint $table) {
            $table->dropIndex(['invoice_type_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['financial_year_id']);
        });

        /*Schema::table('ipd_admissions', function (Blueprint $table) {
            $table->dropIndex(['patient_id']);
            $table->dropIndex(['patient_source_id']);
            $table->dropIndex(['tpa_account_id']);
        });

        Schema::table('ipd_bed_histories', function (Blueprint $table) {
            $table->dropIndex(['ipd_admission_id']);
            $table->dropIndex(['bed_group_id']);
            $table->dropIndex(['bed_no_id']);
        });

        Schema::table('ipd_body_vital_histories', function (Blueprint $table) {
            $table->dropIndex(['ipd_admission_id']);
            $table->dropIndex(['body_vital_id']);
        });

        Schema::table('ipd_consultant_histories', function (Blueprint $table) {
            $table->dropIndex(['ipd_admission_id']);
            $table->dropIndex(['doctor_id']);
        });

        Schema::table('ipd_symptom_histories', function (Blueprint $table) {
            $table->dropIndex(['ipd_admission_id']);
            $table->dropIndex(['symptom_id']);
        });*/

        /*Schema::table('librarian_publishers', function (Blueprint $table) {
            $table->dropIndex(['place_id']);
        });*/

        Schema::table('license_types', function (Blueprint $table) {
            $table->dropIndex(['country_id']);
        });

        /*Schema::table('lms_assignments', function (Blueprint $table) {
            $table->dropIndex(['course_id']);
        });

        Schema::table('lms_class_sections', function (Blueprint $table) {
            $table->dropIndex(['class_id']);
            $table->dropIndex(['academics_section_id']);
        });

        Schema::table('lms_courses', function (Blueprint $table) {
            $table->dropIndex(['category_id']);
            $table->dropIndex(['language_id']);
            $table->dropIndex(['subject_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['class_id']);
            $table->dropIndex(['section_id']);
        });

        Schema::table('lms_course_categories', function (Blueprint $table) {
            $table->dropIndex(['parent_id']);
        });

        Schema::table('lms_video_sources', function (Blueprint $table) {
            $table->dropIndex(['course_id']);
        });*/

        Schema::table('operations', function (Blueprint $table) {
            $table->dropIndex(['category_id']);
        });

        Schema::table('posts', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['category_id']);
        });

        Schema::table('price_settings', function (Blueprint $table) {
            $table->dropIndex(['master_voucher_id']);
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropIndex(['tax_slab_id']);
            $table->dropIndex(['brand_id']);
            $table->dropIndex(['category_id']);
            $table->dropIndex(['composition_id']);
            $table->dropIndex(['primary_unit_id']);
            $table->dropIndex(['alternative_unit_id']);
            $table->dropIndex(['item_type_id']);
            $table->dropIndex(['attribute_type_id']);
            $table->dropIndex(['attribute_id']);
            $table->dropIndex(['instance_id']);
            $table->dropIndex(['gender_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['flag_id']);
            $table->dropIndex(['warehouse_id']);
            $table->dropIndex(['created_by_user_id']);
            $table->dropIndex(['updated_by_user_id']);
        });

        Schema::table('product_alternative_units', function (Blueprint $table) {
            $table->dropIndex(['primary_unit_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('product_attributes', function (Blueprint $table) {
            $table->dropIndex(['product_attribute_type_id']);
        });

        Schema::table('product_images', function (Blueprint $table) {
            $table->dropIndex(['product_id']);
        });

        Schema::table('product_locations', function (Blueprint $table) {
            $table->dropIndex(['product_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['location_rack_id']);
        });

        Schema::table('product_location_racks', function (Blueprint $table) {
            $table->dropIndex(['warehouse_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('product_prices', function (Blueprint $table) {
            $table->dropIndex(['product_id']);
            $table->dropIndex(['main_attribute_id']);
            $table->dropIndex(['sub_attribute_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('product_test_packages', function (Blueprint $table) {
            $table->dropIndex(['product_id']);
            $table->dropIndex(['test_package_id']);
        });

        Schema::table('product_uploads', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
        });

        Schema::table('product_warehouses', function (Blueprint $table) {
            $table->dropIndex(['state_id']);
            $table->dropIndex(['country_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('public_contents', function (Blueprint $table) {
            $table->dropIndex(['public_content_category_id']);
            $table->dropIndex(['sub_category_id']);
        });

        Schema::table('sale_invoices', function (Blueprint $table) {
            $schema_builder = Schema::getConnection()
                ->getDoctrineSchemaManager()
                ->listTableDetails( $table->getTable() );

            if( $schema_builder->hasIndex('voucher_type_id') ) {
                $table->dropIndex(['voucher_type_id']);
            }
            $table->dropIndex(['patient_id']);
            $table->dropIndex(['doctor_id']);
            $table->dropIndex(['collection_agent_id']);
            $table->dropIndex(['refferal_lab_id']);
            $table->dropIndex(['payment_mode_id']);
            $table->dropIndex(['bussiness_source_id']);
            $table->dropIndex(['payment_term_id']);
            $table->dropIndex(['broker_id']);
            $table->dropIndex(['operator_id']);
            $table->dropIndex(['company_id']);
            $table->dropIndex(['financial_year_id']);
            $table->dropIndex(['industry_type_id']);
            $table->dropIndex(['dispatch_from_id']);
            $table->dropIndex(['ship_to_id']);
            $table->dropIndex(['tracking_id']);
            $table->dropIndex(['special_case_id']);
        });

        Schema::table('sale_invoice_deliveries', function (Blueprint $table) {
            $table->dropIndex(['sale_invoice_id']);
            $table->dropIndex(['sale_invoice_detail_id']);
            $table->dropIndex(['delivery_partner_id']);
        });

        Schema::table('sale_invoice_details', function (Blueprint $table) {
            $table->dropIndex(['sale_invoice_id']);
            $table->dropIndex(['product_id']);
            $table->dropIndex(['product_price_id']);
            $table->dropIndex(['tax_slab_id']);
            $table->dropIndex(['godown_id']);
        });

        Schema::table('sale_invoice_sub_details', function (Blueprint $table) {
            $table->dropIndex(['sale_invoice_detail_id']);
            $table->dropIndex(['sale_invoice_id']);
            $table->dropIndex(['data_referrence_id']);
        });

        Schema::table('sale_invoice_walk_in_customers', function (Blueprint $table) {
            $table->dropIndex(['invoice_id']);
            $table->dropIndex(['gender_id']);
        });

        /*Schema::table('sample_types', function (Blueprint $table) {
            $table->dropIndex(['sample_collection_tube_id']);
        });*/

        Schema::table('signature_permissions', function (Blueprint $table) {
            $table->dropIndex(['signatures_id']);
            $table->dropIndex(['test_departments_id']);
        });

        Schema::table('sliders', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
        });

        Schema::table('sms_api_settings', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['principal_entity_id']);
        });

        Schema::table('sms_templates', function (Blueprint $table) {
            $table->dropIndex(['company_id']);
            $table->dropIndex(['template_id']);
            $table->dropIndex(['sender_id']);
        });

        Schema::table('states', function (Blueprint $table) {
            $table->dropIndex(['country_id']);
        });

        /*Schema::table('student_admissions', function (Blueprint $table) {
            $table->dropIndex(['student_id']);
            $table->dropIndex(['financial_id']);
            $table->dropIndex(['class_id']);
            $table->dropIndex(['section_id']);
        });*/

        Schema::table('tax_calculations', function (Blueprint $table) {
            $table->dropIndex(['voucher_master_id']);
        });

        Schema::table('tax_masters', function (Blueprint $table) {
            $table->dropIndex(['tax_category_id']);
        });

        Schema::table('tax_master_subs', function (Blueprint $table) {
            $table->dropIndex(['tax_master_id']);
        });

        Schema::table('tbl_stocks', function (Blueprint $table) {
            $table->dropIndex(['financial_id']);
            $table->dropIndex(['invoice_id']);
            $table->dropIndex(['stock_item_id']);
            $table->dropIndex(['stock_item_price_id']);
            $table->dropIndex(['stock_item_attribute_id']);
            $table->dropIndex(['stock_company_id']);
        });

        /*Schema::table('tc_registers', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
            $table->dropIndex(['class_id']);
        });*/

        /*Schema::table('test_dept_permissions', function (Blueprint $table) {
            $table->dropIndex(['user_id']);
            $table->dropIndex(['test_departments_id']);
        });

        Schema::table('test_items', function (Blueprint $table) {
            $table->dropIndex(['primary_unit_id']);
            $table->dropIndex(['test_method_id']);
            $table->dropIndex(['machine_id']);
        });

        Schema::table('test_item_normal_ranges', function (Blueprint $table) {
            $table->dropIndex(['test_item_id']);
            $table->dropIndex(['special_case_id']);
            $table->dropIndex(['gender_id']);
        });

        Schema::table('test_item_options', function (Blueprint $table) {
            $table->dropIndex(['test_item_id']);
            $table->dropIndex(['style_type_id']);
        });

        Schema::table('test_packages', function (Blueprint $table) {
            $table->dropIndex(['department_id']);
            $table->dropIndex(['sample_type_id']);
        });

        Schema::table('test_package_groups', function (Blueprint $table) {
            $table->dropIndex(['test_package_id']);
        });

        Schema::table('test_package_group_notes', function (Blueprint $table) {
            $table->dropIndex(['test_package_id']);
            $table->dropIndex(['test_package_group_id']);
        });

        Schema::table('test_package_group_test_items', function (Blueprint $table) {
            $table->dropIndex(['test_package_id']);
            $table->dropIndex(['test_package_group_id']);
            $table->dropIndex(['test_item_id']);
        });

        Schema::table('test_package_notes', function (Blueprint $table) {
            $table->dropIndex(['test_package_id']);
        });*/

        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['account_id']);
            $table->dropIndex(['company_id']);
        });

        Schema::table('voucher_series', function (Blueprint $table) {
            $table->dropIndex(['voucher_type_id']);
        });

        Schema::table('voucher_types', function (Blueprint $table) {
            $table->dropIndex(['voucher_master_id']);
        });
    }
};
