<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transactions_no', 16);
            $table->date('transaction_date');
            $table->string('module_code', 255);
            $table->unsignedBigInteger('voucher_id');
            $table->string('voucher_type', 25);
            $table->unsignedBigInteger('account_id');
            $table->enum('transaction_type', ['DEBIT', 'CREDIT']);
            $table->text('details_narration')->nullable();
            $table->decimal('amount', 13, 4)->default(0.0000);
            $table->unsignedInteger('currency_id')->default(0);
            $table->unsignedInteger('created_by')->default(0);
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('financial_year_id');
            $table->unsignedTinyInteger('transactions_status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_transactions');
    }
};
