<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('print_style_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->boolean('show_header')->default(true);
            $table->boolean('show_footer')->default(true);
            $table->enum('show_in_header', ['company_details', 'letter_head'])->default('company_details');
            $table->boolean('show_watermark')->default(false);
            $table->integer('watermark_transparency')->default(50);
            $table->text('watermark')->nullable();
            $table->text('letter_head')->nullable();
            $table->enum('layout', ['portrait', 'landscape'])->default('portrait');
            $table->enum('page_size', ['a4', 'letter'])->default('a4');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('print_style_settings');
    }
};
